<?php include('header.php')?>


  <!-- Start Portfolio Details Area -->
<div class="portfolio-details__hero">
  <div class="container-fluid">
    <h1>Vault ID Face</h1>
    <div class="portfolio-details__items">
      <div class="portfolio-details__item">
        <h4>Function:</h4>
        <p>Passive Facial Liveness Detection</p>
      </div>
      <div class="portfolio-details__item">
        <h4>Built For:</h4>
        <p>Onboarding Platforms, Security Apps & Identity Systems</p>
      </div>
      <div class="portfolio-details__item">
        <h4>Highlights:</h4>
        <p>Single‑Image Check, Zero User Action, Anti‑Spoofing AI</p>
      </div>
      <div class="portfolio-details__item">
        <h4>Integration:</h4>
        <p>Webcam, Mobile Selfie, API/SDK</p>
      </div>
      <div class="portfolio-details__item">
        <h4>Deployment:</h4>
        <p>SDK, Docker, Cloud or On‑Device</p>
      </div>
    </div>
  </div>
</div>
<!-- End Portfolio Details Area -->

<!-- Start Portfolio Details Full Image Area -->
<div class="portfolio-details__full-image hover-overlay">
  <img src="images/work/full-width.jpg" alt="Vault ID Face">
</div>
<!-- End Portfolio Details Full Image Area -->

<!-- Portfolio Portfolio Details Contents Area -->
<div class="portfolio-details__contents">
  <div class="container-fluid">
    <div class="portfolio-details__content">
      <h2>Secure Face Verification with Invisible, One‑Shot Liveness Checks.</h2>
      <h4>Vault ID Face ensures every selfie is from a live person—without prompting a blink, smile, or head‑turn.</h4>
      <ul>
        <li>Single‑Frame Liveness & Spoof Detection</li>
        <li>No User Participation Needed</li>
        <li>ISO‑Compliant Anti‑Spoofing AI</li>
        <li>Lightweight SDK / API Integration</li>
      </ul>
      <p>Built for seamless identity proofing, Vault ID Face analyzes the same image captured for facial recognition—adding a powerful passive liveness layer. Whether you're onboarding users via mobile app or authenticating on the web, it works silently in the background, detecting photo, video, mask, or replay attacks without extra friction.</p>
    </div>
    <div class="portfolio-details__content">
      <h2>01 . The Challenge</h2>
      <p>Face recognition alone can’t tell if a picture is coming from a real person. Fraudsters exploit this with printed photos, digital videos, masks, and deepfakes—trickery that active liveness methods try to counter, but often confuse users and slow the process.</p>
    </div>
    <div class="portfolio-details__content">
      <h2>02 . The Solution</h2>
      <p>Vault ID Face uses deep learning to analyze a single selfie, verify liveness instantly, and flag spoofing attempts—all without any user prompts. Results arrive in under a second, with full ISO‑compliant accuracy and minimal bandwidth, whether deployed via SDK, Docker, or on‑device.</p>
    </div>
    <div class="portfolio-details__thumbnail">
      <img src="images/work/img-1.jpg" alt="Vault ID Face Demo 1">
    </div>
    <div class="portfolio-details__thumbnail">
      <img src="images/work/img-2.jpg" alt="Vault ID Face Demo 2">
    </div>
  </div>
</div>

    <!-- End Portfolio Details Contents Area -->
    <!-- Start Portfolio Details Buttons Area -->
    <div class="page-details__btns">
      <a href="#" class="page-details__btn">Prev Product
        <svg width="23" height="29" viewBox="0 0 23 29" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_232_599)"><path d="M21.0541 24.2467L5.87695 0.716797C6.8219 2.33995 7.7672 9.19256 6.25524 12.3726" stroke="#1A1919"/></g><defs><clipPath id="clip0_232_599"><rect width="8" height="29" fill="white" transform="matrix(-0.840354 0.542039 0.542039 0.840354 6.72266 0.146729)"/></clipPath></defs></svg>          
      </a>
      <a href="#" class="page-details__btn">Next Product
        <svg width="23" height="29" viewBox="0 0 23 29" fill="none" xmlns="http://www.w3.org/2000/svg"><g clip-path="url(#clip0_232_588)"><path d="M1.6686 24.2467L16.8457 0.716797C15.9008 2.33995 14.9555 9.19256 16.4674 12.3726" stroke="#1A1919"/></g><defs><clipPath id="clip0_232_588"><rect width="8" height="29" fill="white" transform="translate(16 0.146729) rotate(32.8225)"/></clipPath></defs></svg>          
      </a>
    </div>
    <!-- End Portfolio Details Buttons Area -->
    <!-- Start Ticker Area -->
    <div class="ticker">
      <div class="ticker__container">
        <div class="ticker__carousel">
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
        </div>
      </div>
    </div>
    <!-- End Ticker Area -->

 <?php include('footer.php')?>