(function ($) {
    "use strict";
    $.fn.meanmenu = function (options) {
        var defaults = {
            meanMenuTarget: jQuery(this),
            meanMenuContainer: 'body',
            meanShowChildren: true,
            meanExpandableChildren: true
        };
        options = $.extend(defaults, options);

        return this.each(function () {
            var meanMenu = options.meanMenuTarget;
            var meanContainer = options.meanMenuContainer;
            var meanScreenWidth = options.meanScreenWidth;
            var meanShowChildren = options.meanShowChildren;
            var meanExpandableChildren = options.meanExpandableChildren;

            var currentWidth = window.innerWidth || document.documentElement.clientWidth;
            var meanMenuExist = false;

            var meanOriginal = function () {
                jQuery('.mean-bar').remove();
                jQuery(meanContainer).removeClass("mean-container");
                jQuery(meanMenu).css('display', "block");
                meanMenuExist = false;
            };

			var showMeanMenu = function () {
				if (currentWidth <= meanScreenWidth) {
					meanMenuExist = true;
					jQuery(meanContainer).addClass("mean-container");
					jQuery(meanContainer).prepend('<div class="mean-bar"><a href="#nav" class="meanmenu-reveal">Menu</a><nav class="mean-nav"></nav></div>');
			
					var meanMenuContents = jQuery(meanMenu).html();
					jQuery('.mean-nav').html(meanMenuContents);
					jQuery(meanMenu).hide();
					jQuery(".meanmenu-reveal").show();
					jQuery('.mean-nav ul').hide();
			
					if (meanShowChildren && meanExpandableChildren) {
						jQuery('.mean-nav ul ul').each(function () {
							jQuery(this).parent('li').children('a').addClass('mean-expand');
						});
			
						jQuery('.mean-expand').on("click", function (e) {
							e.preventDefault();
			
							// Close other open submenus
							jQuery('.mean-expand').not(this).removeClass('mean-clicked').next('ul').slideUp(300);
							jQuery('.mean-expand').not(this).parent().removeClass('dropdown-opened');
			
							// Toggle the current menu
							jQuery(this).toggleClass('mean-clicked');
							jQuery(this).next('ul').slideToggle(300);
							jQuery(this).parent().toggleClass('dropdown-opened');
						});
					} else {
						jQuery('.mean-nav ul ul').show();
					}
				} else {
					meanOriginal();
				}
			};
			

            jQuery(window).resize(function () {
                currentWidth = window.innerWidth || document.documentElement.clientWidth;
                if (currentWidth <= meanScreenWidth) {
                    if (!meanMenuExist) {
                        showMeanMenu();
                    }
                } else {
                    meanOriginal();
                }
            });

            showMeanMenu();
        });
    };
})(jQuery);