<?php include('header.php')?>
    <!-- End Header Area -->
    <!-- Start Hero Area -->
 <div class="hero bg-color">
  <div class="container-fluid">
    <div class="hero__info">
      <div class="hero__header">
        <div class="hero__header-left hover-overlay">
          <img src="images/home1.jpg" alt="Stratio">
        </div>
        <div class="hero__header-middle">
          <div class="hero__header-text">
            <h2>We build</h2>
            <h2>intelligent</h2>
            <div class="typing-text">-AI-Driven Tools</div>
          </div>
        </div>
        <div class="hero__header-right hover-overlay">
          <img src="images/hero/2.png" alt="Stratio">
        </div>
      </div>
      <div class="hero__footer">
        <div class="hero__footer-left">
          <img src="images/hero/3.png" alt="Stratio">
          <a href="#" class="btn btn__dot">
            <span data-text="Contact Us">Contact Us</span>
          </a>
        </div>
        <div class="hero__footer-middle">
          <p>Voxa Vault empowers businesses with tailored AI strategies, intelligent models, and scalable systems to drive transformation and real-world results.</p>
          <div class="hero__footer-content">
            <div class="hero__footer-thumbs">
              <img src="images/hero/thumbs-1.png" alt="Thumbs">
              <img src="images/hero/thumbs-2.png" alt="Thumbs">
              <img src="images/hero/thumbs-3.png" alt="Thumbs">
              <img src="images/hero/thumbs-4.png" alt="Thumbs">
              <img src="images/hero/thumbs-5.png" alt="Thumbs">
            </div>
            <div class="hero__footer-text">
              <h3>1000+</h3>
              <span>AI-Driven Success Stories</span>
            </div>
          </div>
        </div>
        <div class="hero__footer-right hover-overlay">
          <img src="images/home2.jpg" alt="Stratio" class="image-main">
          <img src="images/hero/frame.png" alt="Frame" class="frame">
        </div>
      </div>
    </div>
  </div>
</div>

    <!-- End Hero Area -->
    <!-- Start Brand Area -->
    <div class="brand bg-color section-padding">
      <div class="container-fluid">
        <div class="section-header">
      <h3 class="text-fill">Trusted by innovative companies worldwide</h3>
    </div>
        <div class="brand__info brand__slider">
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/1.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/2.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/3.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/4.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/1.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/2.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/3.svg" alt="Logo">
            </div>
          </div>
          <div class="brand__single">
            <div class="brand__logo">
              <img src="images/brand/4.svg" alt="Logo">
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End Brand Area -->
    <!-- Start About Area -->
   <div class="about bg-color">
  <div class="container-fluid">
    <div class="about__info">
      <h5>About Company</h5>
      <h2 class="text-fill">At Voxa Vault, we design and deliver AI-driven solutions tailored to your business goals—combining strategy, engineering, and innovation to drive real impact.</h2>
      <div class="about__content">
        <p>We help organizations embrace AI not just as a tool, but as a long-term growth enabler. From strategy to implementation, our team works closely with clients to unlock value through intelligent automation, applied models, and scalable platforms. We prioritize clarity, performance, and trust at every stage.</p>
        <a href="#" class="btn btn__dot">
          <span data-text="More About Company">More About Company</span>
        </a>
      </div>
    </div>
    <div class="about__lists">
      <div class="about__list">
        <h3>AI-First Approach</h3>
        <div class="about__list-timer d-flex items-center justify-center">
          <span class="timer" data-from="1" data-to="39" data-speed="5000" data-refresh-interval="50">39</span>
          <span class="timer-right">%</span>
        </div>
        <p>Organizations we support typically experience an average 39% boost in efficiency by integrating AI into their core workflows.</p>
      </div>
      <div class="about__list">
        <h3>Projects Delivered</h3>
        <div class="about__list-timer d-flex items-center justify-center">
          <span class="timer" data-from="1" data-to="295" data-speed="5000" data-refresh-interval="50">295</span>
          <span class="timer-right">+</span>
        </div>
        <p>We’ve successfully delivered 295+ AI and data projects, from model development to full-stack implementation across industries.</p>
      </div>
      <div class="about__list">
  <h3>AI-Powered Workflows</h3>
  <div class="about__list-timer d-flex items-center justify-center">
    <span class="timer" data-from="1" data-to="135" data-speed="5000" data-refresh-interval="50">135</span>
    <span class="timer-right">+</span>
  </div>
  <p>We’ve helped over 135 teams redesign their workflows using intelligent automation, driving faster decisions and scalable outcomes.</p>
</div>

    </div>
    <div class="about__video" id="about__video">
      <div class="about-video__overlay" data-background="images/about-video.jpg">
        <div class="about-video__overlay-content">
          <div class="about-video__overlay-play" id="about-video__overlay-play">Play</div>
        </div>
      </div>
      <div class="about-video__box">
        <div id="about-video__player" data-plyr-provider="youtube" data-plyr-embed-id="TfU0qjuZkJ4"></div>
      </div>
      <div class="about__award">
        <h3>Voxa Vault is trusted by global enterprises to lead their AI journey</h3>
        <div class="about__award-box">
          <img src="images/award.svg" alt="Stratio">
          <div class="about__award-text d-flex align-items-center">
            <span>V.</span>
            <h4>Recognized for excellence in AI innovation</h4>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

    <!-- End About Area -->
    <!-- Start Service Area -->
 <div class="service bg-color section-padding">
  <div class="container-fluid">
    <div class="d-flex align-items-end justify-content-between">
      <div class="section-title">
        <h2 class="text-fill">Service</h2>
      </div>
      <a href="#" class="btn btn__dot">
        <span data-text="View All Services">View All Services</span>
      </a>
    </div>
    <div class="services">
      <div class="service__item active">
        <div class="service__single">
          <div class="service__heading d-flex align-items-center position-relative">
            <span class="number">01</span>
            <span class="title">AI Strategy & Implementation</span>
            <span class="icon"><img src="images/service/plus.svg" alt="Icon"></span>
            <span class="icon-minus"><img src="images/service/minus.svg" alt="Icon"></span>
          </div>
          <div class="service__content">
            <div class="d-flex">
              <div class="service__content-text">
                <p>We help organizations navigate the AI landscape with a clear roadmap, aligning business goals with cutting-edge AI capabilities for sustainable transformation.</p>
                <ul class="service__content-list">
                  <li>AI readiness assessment</li>
                  <li>Strategic AI roadmap planning</li>
                  <li>Innovation pipeline setup</li>
                  <li>Change management support</li>
                </ul>
              </div>
              <div class="service__content-thumbnail">
                <a href="#" class="hover-overlay">
                  <img src="images/service1.jpg" alt="Service">
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="service__item">
        <div class="service__single">
          <div class="service__heading d-flex align-items-center position-relative">
            <span class="number">02</span>
            <span class="title">Machine Learning & Model Development</span>
            <span class="icon"><img src="images/service/plus.svg" alt="Icon"></span>
            <span class="icon-minus"><img src="images/service/minus.svg" alt="Icon"></span>
          </div>
          <div class="service__content">
            <div class="d-flex">
              <div class="service__content-text">
                <p>From data to deployment, we build robust machine learning models that solve real-world challenges and create measurable value for your business.</p>
                <ul class="service__content-list">
                  <li>Custom model development</li>
                  <li>Predictive analytics solutions</li>
                  <li>Deep learning applications</li>
                  <li>Model evaluation & fine-tuning</li>
                </ul>
              </div>
              <div class="service__content-thumbnail">
                <a href="#" class="hover-overlay">
                  <img src="images/service2.jpg" alt="Service">
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="service__item">
        <div class="service__single">
          <div class="service__heading d-flex align-items-center position-relative">
            <span class="number">03</span>
            <span class="title">Data Engineering & MLOps</span>
            <span class="icon"><img src="images/service/plus.svg" alt="Icon"></span>
            <span class="icon-minus"><img src="images/service/minus.svg" alt="Icon"></span>
          </div>
          <div class="service__content">
            <div class="d-flex">
              <div class="service__content-text">
                <p>We architect scalable data pipelines and streamline model operations so your AI systems remain reliable, secure, and high-performing over time.</p>
                <ul class="service__content-list">
                  <li>ETL and data pipeline design</li>
                  <li>Cloud-native data architecture</li>
                  <li>CI/CD for ML models</li>
                  <li>Model monitoring & retraining</li>
                </ul>
              </div>
              <div class="service__content-thumbnail">
                <a href="#" class="hover-overlay">
                  <img src="images/service3.jpg" alt="Service">
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="service__item">
        <div class="service__single">
          <div class="service__heading d-flex align-items-center position-relative">
            <span class="number">04</span>
            <span class="title">Applied AI Solutions</span>
            <span class="icon"><img src="images/service/plus.svg" alt="Icon"></span>
            <span class="icon-minus"><img src="images/service/minus.svg" alt="Icon"></span>
          </div>
          <div class="service__content">
            <div class="d-flex">
              <div class="service__content-text">
                <p>We build end-to-end AI applications tailored to your industry—boosting efficiency, automating tasks, and enhancing customer experiences.</p>
                <ul class="service__content-list">
                  <li>AI-driven automation</li>
                  <li>Industry-specific use cases</li>
                  <li>Conversational AI systems</li>
                  <li>Intelligent document processing</li>
                </ul>
              </div>
              <div class="service__content-thumbnail">
                <a href="#" class="hover-overlay">
                  <img src="images/service4.png" alt="Service">
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

    </div>
  </div>
</div>

    <!-- End Service Area -->
    <!-- Start Process Area -->
   <div class="process section-padding">
  <div class="container-fluid">
    <div class="process__items">
      <div class="process__item">
        <span class="d-flex align-items-center justify-content-center text-uppercase">Step 01</span>
        <img src="images/service/concept.svg" alt="Concept">
        <h3>Discovery</h3>
        <p>We begin by understanding your business needs, current data landscape, and AI opportunities to align our approach with your goals.</p>
      </div>
      <div class="process__item">
        <span class="d-flex align-items-center justify-content-center text-uppercase">Step 02</span>
        <img src="images/service/design.svg" alt="Design">
        <h3>Design</h3>
        <p>Our team creates a tailored AI strategy, selecting the right models, data pipelines, and architecture to fit your specific use case.</p>
      </div>
      <div class="process__item">
        <span class="d-flex align-items-center justify-content-center text-uppercase">Step 03</span>
        <img src="images/service/development.svg" alt="Development">
        <h3>Development</h3>
        <p>We build, test, and optimize machine learning models and data systems, ensuring everything is production-ready and scalable.</p>
      </div>
      <div class="process__item">
        <span class="d-flex align-items-center justify-content-center text-uppercase">Step 04</span>
        <img src="images/service/launch.svg" alt="Launch">
        <h3>Deployment</h3>
        <p>After rigorous testing, we deploy your AI solution into real-world environments—complete with monitoring and continuous improvement.</p>
      </div>
    </div>
  </div>
</div>

    <!-- End Process Area -->
    <!-- Start Work Area -->
  <div class="work bg-color section-padding">
  <div class="container-fluid">
    <div class="d-flex align-items-end justify-content-between">
      <div class="section-title">
        <h2 class="text-fill">Why Choose</h2>
      </div>
      <a href="#" class="btn btn__dot">
        <span data-text="Explore More">Explore More</span>
      </a>
    </div>
    <div class="section-subtitle">
      <h3>Built for scale. Backed by results. Trusted by teams who move fast.</h3>
    </div>
  </div>
  <div class="project__hover-title"></div>
  <div class="work__items project__hovers">
    <div class="work__item project__hover pixels-animation">
      <a href="#" data-title="Lightning-Fast Implementation">
        <img src="images/slide1.png" alt="Implementation">
      </a>
    </div>
    <div class="work__item project__hover pixels-animation">
      <a href="#" data-title="Enterprise-Grade Security">
        <img src="images/slide2.png" alt="Security">
      </a>
    </div>
    <div class="work__item project__hover pixels-animation">
      <a href="#" data-title="Seamless Integrations">
        <img src="images/slide3.png" alt="Integrations">
      </a>
    </div>
    <div class="work__item project__hover pixels-animation">
      <a href="#" data-title="Proven Engagement Boost">
        <img src="images/slide4.png" alt="Engagement">
      </a>
    </div>
    <div class="work__item project__hover pixels-animation">
      <a href="#" data-title="24/7 Customer Support">
        <img src="images/slide5.png" alt="Support">
      </a>
    </div>
  </div>
</div>

    <!-- End Work Area -->
    <!-- Start Award Area -->
  <div class="award bg-color pb-120">
  <div class="award__ticker">
    <div class="award__heading">
      <h2>milestones & impact -</h2>
      <h2>milestones & impact -</h2>
      <h2>milestones & impact -</h2>
    </div>
    <div class="award__heading">
      <h2>milestones & impact -</h2>
      <h2>milestones & impact -</h2>
      <h2>milestones & impact -</h2>
    </div>
  </div>
  <div class="container-fluid">
    <div class="award__items">
      <div class="award__item d-flex align-items-center position-relative">
        <div class="award__item-tooltip" data-tooltip-image="images/award/1.jpg"></div>
        <span>I</span>
        <h3>Launched 25+ Custom AI Solutions</h3>
        <h4>February 10, 2024</h4>
      </div>
      <div class="award__item d-flex align-items-center position-relative">
        <div class="award__item-tooltip" data-tooltip-image="images/award/2.jpg"></div>
        <span>II</span>
        <h3>1M+ Data Pipelines Automated</h3>
        <h4>July 10, 2024</h4>
      </div>
      <div class="award__item d-flex align-items-center position-relative">
        <div class="award__item-tooltip" data-tooltip-image="images/award/3.jpg"></div>
        <span>III</span>
        <h3>Recognized for Ethical AI Frameworks</h3>
        <h4>November 05, 2023</h4>
      </div>
      <div class="award__item d-flex align-items-center position-relative">
        <div class="award__item-tooltip" data-tooltip-image="images/award/4.jpg"></div>
        <span>IV</span>
        <h3>Scaled AI for 10+ Global Enterprises</h3>
        <h4>June 28, 2023</h4>
      </div>
      <div class="award__item d-flex align-items-center position-relative">
        <div class="award__item-tooltip" data-tooltip-image="images/award/5.jpg"></div>
        <span>V</span>
        <h3>Launched MLOps Platform Beta</h3>
        <h4>August 29, 2023</h4>
      </div>
    </div>
  </div>
</div>

    <!-- End Award Area -->
    <!-- Start Review Area -->
  <div class="review section-padding">
  <div class="container-fluid">
    <div class="d-flex align-items-end justify-content-between">
      <div class="section-title">
        <h2 class="text-fill">Reviews</h2>
      </div>
      <a href="#" class="btn btn__dot">
        <span data-text="Discover More">Discover More</span>
      </a>
    </div>
    <div class="section-subtitle">
      <h3>What our clients say about us</h3>
      <div class="icon">
        <img src="images/review/icon.svg" alt="Icon">
      </div>
    </div>
  </div>      
  <div class="review__block">
    <div class="review__items">
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Voxa Vault helped us turn a complex data project into a seamless, scalable solution. Their clarity and technical depth made a huge difference.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/1.jpg" alt="Sophia Martinez">
          </div>
          <div class="review__item-info">
            <h3>Sophia Martinez</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Impressive delivery. Their AI model implementation streamlined our workflows and revealed insights we couldn’t see before.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/2.jpg" alt="Savannah Nguyen">
          </div>
          <div class="review__item-info">
            <h3>Blake Thompson</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Working with Voxa Vault felt like adding a senior AI team to our in-house staff. They got our goals immediately and executed fast.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/3.jpg" alt="David Backham">
          </div>
          <div class="review__item-info">
            <h3>James Walker</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>We needed a custom AI integration for our platform — Voxa delivered exactly what we needed, and ahead of schedule.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/4.jpg" alt="Daniel Wright">
          </div>
          <div class="review__item-info">
            <h3>Farhan Chowdhury</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Our experience with Voxa Vault was smooth and efficient. Their team knew exactly how to handle our data challenges.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/5.jpg" alt="Smith Ongru">
          </div>
          <div class="review__item-info">
            <h3>Neil Iyer</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>The results were beyond our expectations. Their AI systems helped improve our customer experience in under a month.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/1.jpg" alt="Sophia Martinez">
          </div>
          <div class="review__item-info">
            <h3>Sophia Martinez</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>They brought clarity to a technical space. We finally have a future-ready data infrastructure thanks to their input.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/2.jpg" alt="Savannah Nguyen">
          </div>
          <div class="review__item-info">
            <h3>Avery Morgan</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Voxa Vault didn’t just consult — they partnered with us. Every step was tailored, insightful, and well-communicated.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/3.jpg" alt="David Backham">
          </div>
          <div class="review__item-info">
            <h3>Olivia Hayes</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>We’ve worked with other tech vendors before, but this felt different — more invested, more transparent, and very sharp technically.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/4.jpg" alt="Daniel Wright">
          </div>
          <div class="review__item-info">
            <h3>Caleb Mitchell</h3>
          </div>
        </div>
      </div>
      <div class="review__item">
        <img src="images/review/quote.svg" alt="Icon">
        <p>Reliable and forward-thinking. They supported our AI vision from planning through deployment — and even beyond.</p>
        <div class="d-flex align-items-center">
          <div class="review__item-avatar">
            <img src="images/review/5.jpg" alt="Smith Ongru">
          </div>
          <div class="review__item-info">
            <h3>Marcus Riley</h3>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

    <!-- End Review Area -->
    <!-- Start CTA Area -->
    <div class="cta bg-color pt-120">
     <div class="cta__info">
  <h5>Let’s Build What’s Next</h5>
  <div class="section-subtitle">
    <h3 class="text-fill">Have an AI idea or data challenge? Let’s bring it to life—together.</h3>
  </div>
  <div class="cta__form">      
    <form action="#">
      <div class="d-flex">
        <input type="text" placeholder="Enter Your Email">
        <button type="submit">
          <img src="images/paper-plane.svg" alt="Icon">
        </button>
      </div>
    </form>
  </div>  
</div>

      <div class="container-fluid">
        <div class="cta__block position-relative">
          <div class="cta__thimbnail-left">
            <div class="cta__thimbnail">
              <img src="images/tile1.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">
              <img src="images/tile2.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">            
              <img src="images/tile3.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">            
              <img src="images/tile4.png" alt="Thumbnail">
            </div>
          </div>
          <div class="cta__thimbnail-right">
            <div class="cta__thimbnail">
              <img src="images/tile5.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">
              <img src="images/tile6.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">            
              <img src="images/tile7.png" alt="Thumbnail">
            </div>
            <div class="cta__thimbnail">            
              <img src="images/tile8.png" alt="Thumbnail">
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- End CTA Area -->
    <!-- Start News Area -->
   
    <!-- End News Area -->
    <!-- Start Ticker Area -->
    <div class="ticker">
      <div class="ticker__container">
        <div class="ticker__carousel">
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
          <div class="ticker__slide">
            <span>Work with us - Let's Chat -</span>
          </div>
        </div>
      </div>
    </div>
    <!-- End Ticker Area -->
    <!-- Start Footer Area -->
   <?php include('footer.php')?>